#include <stdarg.h>
#include <stdlib.h>

#ifndef WIN32
#include <sys/param.h>
#include <sys/stat.h>
#endif

#ifdef WIN32
#pragma warning(disable: 4190)
#pragma warning(disable: 4800)
#endif /* WIN32 */

#include <maya/MStatus.h>
#include <maya/MObject.h>
#include <maya/MFnPlugin.h>
#include <maya/MString.h>
#include <maya/MStringArray.h>
#include <maya/MPxFileTranslator.h>
#include <maya/MGlobal.h>
#include <maya/MFnDagNode.h>
#include <maya/MItDag.h>
#include <maya/MObject.h>
#include <maya/MPlug.h>
#include <maya/MItSelectionList.h>
#include <maya/MSelectionList.h>
#include <maya/MAnimControl.h>
#include <maya/MDistance.h>
#include <maya/MFloatArray.h>

#include <iostream.h>
#include <fstream.h>
#include <string.h>

#include <MDt.h>
#include <MDtExt.h>

#include "rwcommon.h"
#include "material.h"
#include "animation.h"
#include "remapper.h"
#include "scene.h"
#include "mayadff.h"
#include "global.h"

#ifdef WIN32
#define MAXPATHLEN 512
#endif

GlobalData *globalData;

/* ====================================== */
/* Get path name from a full path	 */
/* ====================================== */
char *
MDt_GetPathName (char *LFullStr, char *LRet, int LMaxLen)
{
    register int	LC;
    register int    LLen,
                    LLastSlashPos;

    LLastSlashPos = -1;
    for (LC = 0; LFullStr[LC] != '\0'; LC++)
    {
        if (LFullStr[LC] == '/')
            LLastSlashPos = LC;
    }

    LLen = LLastSlashPos + 1;

    if (LRet == NULL)
        return (NULL);

    LC = 0;
    if ((LRet != NULL) && ((LLen + 1) <= LMaxLen))
    {
        for (; LC < LLen; LC++)
            LRet[LC] = LFullStr[LC];
    }
    LRet[LC] = '\0';

    return (LRet);
}


GlobalData::GlobalData()
{
    m_preLight              = false;
    m_exportNormals         = true;
    m_scaleType             = SCALEBY;
    m_scaleFactor           = 1.0f;
    m_morphTargets          = false;
    m_morphSampleNotKeys    = false;
    m_morphTargetInterval   = 1;
    m_animSeq               = false;
    m_verbose               = false;
    m_animStart             = -1;
    m_animEnd               = -1;
    m_triStrips             = false;
    m_triStripper           = TRISTRIP_DEFAULT;
    m_limitUVs              = false;
    m_uvLimit               = 16.0f;
    m_defaultAnimName       = NULL;
    m_exportKL              = false;
    m_optimiseHierarchy     = false;
    m_cullDff               = false;
    
    m_exportRpSkinWeighting = false;
    m_exportRpAnim          = false;
    m_exportRpSkin          = false;
    m_exportRpHAnim         = false;
    m_rpHAnimSubHierarchy   = false;
    m_rpHAnimLocalMatrices  = false;
    m_rpHAnimNoMatrices     = false;

    gSkinClusterList        = NULL;
    gIkHandleList           = NULL;
    gDagPathBoneIndexList   = NULL;

    hierarchyRootShape      = -1;
    hierarchyRootFrame      = NULL;
    skinAtomic              = NULL;
    currentBoneIndex        = 0;
    vertexMap               = NULL;
    underSelectedMdtShape   = false;    
}

void* dffTranslator::creator()
{
    return new dffTranslator();
}


/* The reader isn't implemented yet. And probably never will be */
MStatus dffTranslator::reader(const MFileObject & file,
                              const MString & options,
                              MPxFileTranslator::FileAccessMode mode)
{
    MStatus rval (MS::kSuccess);

    return rval;
}

/* Write method of the dff translator / file exporter */
MStatus dffTranslator::writer(const MFileObject & fileObject,
                              const MString & options,
                              MPxFileTranslator::FileAccessMode mode)
{
    char            LTmpStr[MAXPATHLEN];
    const MString   fname = fileObject.fullName ();
    MString         extension;
    MString         baseFileName;
    char            sceneName[MAXPATHLEN];
    unsigned int    i;
    MStatus         status;
    exportScene     *scene;

    globalData = new GlobalData;

    /* Lets add the known extension of .dff if it isn't there */
    extension.set (".dff");
    int  extLocation = fileObject.name ().rindex ('.');
    baseFileName = fileObject.name ();

    if (extLocation == 0)
    {
        /* add the extension */
        baseFileName = baseFileName + extension;
    }
    strncpy(sceneName, baseFileName.asChar(), MAXPATHLEN-1);
    globalData->m_animStart  = -1;
    globalData->m_animEnd    = -1;

    /* Lets now do all of the option processing	*/
    if (options.length () > 0)
    {
        /* Start parsing. */

        MStringArray optionList;
        MStringArray theOption;

        /* Split the options into a new string array */
        options.split (';', optionList);

        for (i = 0; i < optionList.length (); ++i)
        {
            /* split the next option into name and value */
            theOption.clear ();
            optionList[i].split ('=', theOption);
            if (theOption.length () > 1)
            {
                if (theOption[0] == MString("dffScaleType"))
                {
                    int type = (int) (theOption[1].asInt());
                    if (type == 1)
                    {
                        globalData->m_scaleType = SCALEBY;
                    }
                    else if (type == 2)
                    {
                        globalData->m_scaleType = SCALETO;
                    }
                }
                else if (theOption[0] == MString("dffCoordinateSystem"))
                {
                    int type = (int) (theOption[1].asInt());
                    if (type == 1)
                    {
                        globalData->m_coordinateSystem = LOCAL;
                    }
                    else if (type == 2)
                    {
                        globalData->m_coordinateSystem = WORLD;
                    }
                }
                else if (theOption[0] == MString("dffScaleFactor"))
                {
                    globalData->m_scaleFactor = (float) (theOption[1].asFloat());

                }
                else if (theOption[0] == MString("dffExportPreLight"))
                { 
                    globalData->m_preLight = (bool) (theOption[1].asInt());
                
                }
                else if (theOption[0] == MString("dffExportNormals"))
                { 
                    globalData->m_exportNormals = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffExportSkinWeighting"))
                { 
                    globalData->m_exportRpSkinWeighting = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffOptimizeHierarchy"))
                {
                    globalData->m_optimiseHierarchy = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffCullDff"))
                {
                    globalData->m_cullDff = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString ("dffAnimStart"))
                { 
                    if (theOption[0] != MString("Start") &&
                        theOption[1].isInt () == true)
                    {
                        globalData->m_animStart = (int) (theOption[1].asInt());
                    }

                }
                else if (theOption[0] == MString("dffAnimEnd"))
                { 
                    if (theOption[0] != MString("End") &&
                        theOption[1].isInt () == true)
                    {
                        globalData->m_animEnd = (int) (theOption[1].asInt());
                    }

                }
                else if (theOption[0] == MString("dffMorphTargets"))
                { 
                    globalData->m_morphTargets = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffSampleMorphTargets"))
                { 
                    globalData->m_morphSampleNotKeys = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffMorphTargetSampleInterval"))
                {
                    globalData->m_morphTargetInterval = (int) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffAnimDefaultName"))
                { 
                    globalData->m_defaultAnimName = _strdup(theOption[1].asChar());

                }
                else if (theOption[0] == MString("dffRpAnim"))
                {
                    globalData->m_exportRpAnim = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffAnimSeq"))
                {
                    globalData->m_animSeq = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffRpSkin"))
                {                    
                    globalData->m_exportRpSkin = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffRpHAnim"))
                {                    
                    globalData->m_exportRpHAnim = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffRpHAnimSubHierarchy"))
                {                    
                    globalData->m_rpHAnimSubHierarchy = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffRpHAnimLocalMatrices"))
                {                    
                    globalData->m_rpHAnimLocalMatrices = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffRpHAnimNoMatrices"))
                {                    
                    globalData->m_rpHAnimNoMatrices = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffKeyframeGeneration"))
                {                    
                    globalData->m_dynamicKeyframeGeneration = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffKeyframeGenerationTolerance"))
                {                    
                    globalData->m_keyframeGenerationTolerance = (theOption[1].asFloat());

                }
                else if (theOption[0] == MString("dffVerbose"))
                {
                    globalData->m_verbose = (int) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffTriStrip"))
                {
                    globalData->m_triStrips = (int) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffTriStripper"))
                {
                    globalData->m_triStripper = (TriStripper) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffLimitUVs"))
                {
                    globalData->m_limitUVs = (bool) (theOption[1].asInt());

                }
                else if (theOption[0] == MString("dffUVLimit"))
                {
                    globalData->m_uvLimit = (float) (theOption[1].asFloat());

                }
            }
        }
    }

    /* setup the start and end of the animation */
    if (globalData->m_animStart == -1)
    {
        MTime start(MAnimControl::minTime().value(), MTime::uiUnit());
        globalData->m_animStart = (int) start.value();
    }

    if (globalData->m_animEnd == -1)
    {
        MTime end(MAnimControl::maxTime().value(), MTime::uiUnit());
        globalData->m_animEnd = (int) end.value();	
    }

    /* Check it doesn't start after it ends, if so swap */
    if (globalData->m_animStart > globalData->m_animEnd)
    {
        int temp;

        temp = globalData->m_animStart;
        globalData->m_animStart = globalData->m_animEnd;
        globalData->m_animEnd = temp;
    }

    globalData->m_animLength = globalData->m_animEnd - globalData->m_animStart + 1;

    /*
        Reset the texture warning so that it gets issued for the first
        truncated texture of each export.
    */
    globalData->m_textureNameWarning = true;

    /*
        Set the working directory to be the export
        destination.
    */
    MDt_GetPathName ((char *) (fname.asChar ()), LTmpStr, MAXPATHLEN);

    if (LTmpStr[strlen (LTmpStr) - 1] == '/')
    {
        LTmpStr[strlen (LTmpStr) - 1] = '\0';
    }
    
    DtSetDirectory (LTmpStr);

    if (!globalData->m_defaultAnimName)
    {
        globalData->m_defaultAnimName = _strdup("default");
    }
    
    printf("\nStarting export of %s\n", sceneName);

    /* Create an export scene and export it's contents */
    scene = new exportScene;
    status = scene->exportDff(sceneName);
    
    delete scene;
    delete globalData;
    
    printf("Finished export of %s\n", sceneName);

    return status;
}

/* no read method */
bool dffTranslator::haveReadMethod() const
{
	return false;
}

/* yes we can write */
bool dffTranslator::haveWriteMethod() const
{
	return true;
}

/* what's the default extension */
MString dffTranslator::defaultExtension() const
{
	return MString("dff");
}

bool dffTranslator::canBeOpened() const
{
	return true;
}

/* we own files with .dff in their name */
MPxFileTranslator::MFileKind dffTranslator::identifyFile (
          const MFileObject & fileName,
          const char *buffer,
          short size) const
{
    MFileKind rval = kNotMyFileType;

    if (strstr(fileName.fullName ().asChar(), ".dff"))
    {
        rval = kIsMyFileType;
    }
    return rval;
}

extern "C" MStatus 
initializePlugin(MObject obj)
{
    MStatus     status;
    char        dffVersion[100];

    sprintf(dffVersion, "3.10 - %s", __DATE__);

    MFnPlugin plugin (obj, "Criterion Software", dffVersion, "Any");

    /* Register the translator with the system */
    status = plugin.registerFileTranslator ("RenderWare dff",
                            "dffTranslator.ico",
                            dffTranslator::creator,
                            "dffTranslatorOpts", "",
                            true);
    if (!status)
    {
        status.perror ("registerFileTranslator");
    }

    return status;
}

extern "C" MStatus 
uninitializePlugin (MObject obj)
{
    MStatus         status;
    MFnPlugin       plugin (obj);

    status = plugin.deregisterFileTranslator ("RenderWare dff");
    if (!status)
    {
        status.perror("deregisterFileTranslator");
    }

    return status;
}

#ifdef WIN32
#pragma warning(default: 4190)
#pragma warning(default: 4800)
#endif /* WIN32 */
